<?php

class Cliente
{
  static function Create($pdo,
    $nome, $cpf, $email, $senhaHash, $dataNascimento, $estadoCivil, $altura,
    $cep, $logradouro, $bairro, $cidade) 
  {
    try {
      $pdo->beginTransaction();

      // Insira o código para inserir os dados adequadamente nas tabelas
      // correlacionadas cliente e enderecoCliente utilizando prepared statements
      // e transações. Inserção parcial (em apenas uma tabela) nunca deve acontecer.
      

    } 
    catch (Exception $e) {

      
      throw $e;
    }

    // retorna o Id do novo cliente criado
    return $pdo->lastInsertId();
  }

  static function GetFirst30($pdo)
  {
    // Neste exemplo não é necessário utilizar prepared statements
    // porque não há a possibilidade de inj. de S Q L, 
    // pois nenhum parâmetro do usuário é utilizado na query SQL. 
    $stmt = $pdo->query(
      <<<SQL
      SELECT cliente.id, nome, cpf, email, senhaHash, DATE_FORMAT(dataNascimento, "%d-%m-%Y") as dataNascimento, 
        estadoCivil, altura, cep, logradouro, bairro, cidade
      FROM cliente INNER JOIN enderecoCliente ON cliente.id = enderecoCliente.idCliente
      LIMIT 30
      SQL
    );

    // Resgata os dados dos clientes como um array de objetos
    $arrayClientes = $stmt->fetchAll(PDO::FETCH_OBJ);
    return $arrayClientes;
  }
}
